Contracts = {}

Contracts.modDirectory = g_currentModDirectory

function Contracts:init()

    MissionManager.initDataStructures = Utils.appendedFunction(MissionManager.initDataStructures, Contracts.initDataStructures)
    MissionManager.loadMapData = Utils.appendedFunction(MissionManager.loadMapData, Contracts.initDataStructures)

    InGameMenuContractsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuContractsFrame.onFrameOpen, Contracts.onFrameOpen)
    InGameMenuContractsFrame.onFrameClose = Utils.appendedFunction(InGameMenuContractsFrame.onFrameClose, Contracts.onFrameClose)
    AbstractMission.hasLeasableVehicles = Utils.overwrittenFunction(AbstractMission.hasLeasableVehicles, Contracts.hasLeasableVehicles)

    MissionManager.loadMapData = Utils.appendedFunction(MissionManager.loadMapData, Contracts.loadMissionVehicles)
    HarvestMission.finishedPreparing = Utils.appendedFunction(HarvestMission.finishedPreparing, Contracts.changedExpectedLiters)
end

function Contracts:onFrameOpen()
    Contracts:addButtons(self)

end

function Contracts:addButtons(menuFrame)
    local menuContainer = g_inGameMenu.menuButton[1].parent
    local menuButton = g_inGameMenu.menuButton[1]
    if g_inGameMenu.newContractsButton == nil then
        g_inGameMenu.newContractsButton = menuButton:clone(menuFrame)
        g_inGameMenu.newContractsButton.onClickCallback = Contracts.onClickNewCallback
        g_inGameMenu.newContractsButton:setText(g_i18n:getText("new_contracts"))
        g_inGameMenu.newContractsButton:setInputAction("MENU_EXTRA_1")
    end

    if g_inGameMenu.clearContractsButton == nil then
        g_inGameMenu.clearContractsButton = menuButton:clone(menuFrame)
        g_inGameMenu.clearContractsButton.onClickCallback = Contracts.onClickClearCallback
        g_inGameMenu.clearContractsButton:setText(g_i18n:getText("clear_contracts"))
        g_inGameMenu.clearContractsButton:setInputAction("MENU_EXTRA_2")
    end
    menuContainer:addElement(g_inGameMenu.newContractsButton)
    menuContainer:addElement(g_inGameMenu.clearContractsButton)
    menuContainer:invalidateLayout()


    local clearAddVisble = g_r_contracts.allowClearAdd == 2

    g_inGameMenu.clearContractsButton.visible = clearAddVisble
    g_inGameMenu.newContractsButton.visible = clearAddVisble
end

function Contracts:hasLeasableVehicles()
    local canLeaseVehicles = g_r_contracts.leaseVehicle == 2
    return canLeaseVehicles and self.vehiclesToLoad ~= nil and table.getn(self.vehiclesToLoad) > 0
end


function Contracts:onFrameClose()
    if  g_inGameMenu.clearContractsButton == nil then
        return
    end
    g_inGameMenu.clearContractsButton.visible = false
    g_inGameMenu.newContractsButton.visible = false
end

function Contracts:onClickNewCallback()
    g_client:getServerConnection():sendEvent(CreateContractsEvent:new())
end

function Contracts:onClickClearCallback()
    g_client:getServerConnection():sendEvent(ClearContractsEvent:new())
end

function Contracts:initDataStructures()
    MissionManager.MAX_MISSIONS = 100
    MissionManager.ACTIVE_CONTRACT_LIMIT = 50
    MissionManager.MAX_MISSIONS_PER_GENERATION = 10 --4
    MissionManager.MAX_TRIES_PER_GENERATION = 20 --5
    MissionManager.MAX_MISSIONS_PER_FARM = 25
    MissionManager.MAX_TRIES_PER_GENERATION = 100
end

function Contracts:loadMissionVehicles(superFunc, path)
    local newPath = Utils.getFilename("missionVehicles.xml", Contracts.modDirectory)
    Contracts:addDLCVehicles()
    g_missionManager.missionVehicles = {}
    g_missionManager:loadVehicleGroups(newPath, Contracts.modDirectory)
    for _, info in ipairs(g_missionManager.pendingMissionVehicleFiles) do
        g_missionManager:loadVehicleGroups(info[1], info[2])
    end
    for _, info in ipairs(g_missionManager.extraMissionVehicles) do
        Contracts:loadVehicleGroups(info[1], info[2])
    end
end

function Contracts:addDLCVehicles()
    if g_missionManager.extraMissionVehicles == nil then
        g_missionManager.extraMissionVehicles = {}
    end

    if g_modIsLoaded["pdlc_nexatPack"] then
        local newPath = Utils.getFilename("nexat.xml", Contracts.modDirectory)
        local foundPosition = 0

        for index, info in ipairs(g_missionManager.pendingMissionVehicleFiles) do
            if string.find(info[1],"pdlc/nexatPack") ~= nil then
                foundPosition = index
            end

        end

        if foundPosition > 0 then
            table.remove(g_missionManager.pendingMissionVehicleFiles, foundPosition)
        end

        local newEntry = {}
        table.insert(newEntry, newPath)
        table.insert(newEntry, Contracts.modDirectory)
        table.insert(g_missionManager.extraMissionVehicles, newEntry)
    end
end

function Contracts:getItemByXMLFilename( xmlFilename)
    local file = nil
    if xmlFilename ~= nil then
        file = g_storeManager.xmlFilenameToItem[xmlFilename:lower()]
    end
    if file ~= nil then
        return file
    end
    if string.startsWith(xmlFilename, "rgbase") then
        local sub = string.gsub(xmlFilename, "^rgbase/", "")
        for index, entry in pairs(g_storeManager.xmlFilenameToItem) do
            if string.contains(entry["xmlFilename"], sub) then
                return entry
            end
        end
    end

    return nil
end

function Contracts:loadVehicleGroups(xmlFilename, baseDirectory)
    local xmlFile = XMLFile.load("MissionVehicles", xmlFilename, MissionManager.xmlSchema)
    if xmlFile == nil then
        return false
    end

    for _, missionKey in xmlFile:iterator("missionVehicles.mission") do
        local missionTypeName = xmlFile:getValue(missionKey .. "#type")
        if missionTypeName == nil then
            Logging.xmlError(xmlFile, "Property type must exist on each mission - '%s'", missionKey)
            continue
        end

        local missionType = g_missionManager:getMissionType(missionTypeName)
        if missionType == nil then
            Logging.xmlError(xmlFile, "Mission type '%s' is not defined - '%s'", missionTypeName, missionKey)
            continue
        end

        if g_missionManager.missionVehicles[missionTypeName] == nil then
            g_missionManager.missionVehicles[missionTypeName] = {}
        end
        local groups = g_missionManager.missionVehicles[missionTypeName]

        for _, groupKey in xmlFile:iterator(missionKey .. ".group") do
            local size = xmlFile:getValue(groupKey .. "#size", "medium")
            local rewardScale = xmlFile:getValue(groupKey .. "#rewardScale", 1.0)
            local success = true
            local vehicles = {}
            local group = {
                rewardScale = rewardScale,
                vehicles = vehicles,
                variant = xmlFile:getValue(groupKey .. "#variant"),
            }

            for _, vehicleKey in xmlFile:iterator(groupKey .. ".vehicle") do
                local vehicleXMLFilename = Utils.getFilename(xmlFile:getValue(vehicleKey .. "#filename"), baseDirectory)
                if vehicleXMLFilename == nil then
                    success = false
                    Logging.xmlError(xmlFile, "Missing 'filename' attribute for vehicle %q", vehicleKey)
                    break
                end

                local storeItem = Contracts:getItemByXMLFilename(vehicleXMLFilename)
                if storeItem == nil then
                    success = false
                    Logging.xmlError(xmlFile, "Unable to load store item for xml filename '%q at %q", vehicleXMLFilename, vehicleKey)
                    break
                end

                vehicleXMLFilename = storeItem["xmlFilename"]

                -- Read configurations
                local configurations
                for _, configKey in xmlFile:iterator(vehicleKey .. ".configuration") do
                    local name = xmlFile:getValue(configKey .. "#name")
                    local id = xmlFile:getValue(configKey .. "#id")

                    if name == nil then
                        Logging.xmlError(xmlFile, "Missing 'name' attribute for configuration at %q", configKey)
                        continue
                    end
                    if id == nil then
                        Logging.xmlError(xmlFile, "Missing 'id' attribute for configuration %q at %q", name, configKey)
                        continue
                    end
                    configurations = configurations or {}
                    configurations[name] = id
                end

                table.insert(vehicles, {
                    filename = vehicleXMLFilename,
                    configurations = configurations
                })
            end

            if success then
                if groups[size] == nil then
                    groups[size] = {}
                end

                table.insert(groups[size], group)
                group.identifier = #groups[size]
            end
        end
    end

    xmlFile:delete()

    return true
end

function Contracts.changedExpectedLiters()
    if g_modIsLoaded["FS25_precisionFarming"] then
        self.expectedLiters = self.expectedLiters * 0.9
    end
end

Contracts:init()