---
--- Created by Ragman2414.
---


ClearContractsEvent= {}
ClearContractsEvent_mt = Class(ClearContractsEvent, Event)
InitEventClass(ClearContractsEvent, "ClearContractsEvent")

---Create instance of Event class
-- @return table self instance of class event
function ClearContractsEvent.emptyNew()
    local self = Event.new(ClearContractsEvent_mt)
    return self
end


---Create new instance of event
-- @param table object object
-- @param boolean isBlocked is blocked
function ClearContractsEvent.new()
    local self = ClearContractsEvent.emptyNew()
    return self
end


---Called on client side on join
-- @param integer streamId streamId
-- @param integer connection connection
function ClearContractsEvent:readStream(streamId, connection)
    self:run(connection)
end


---Called on server side on join
-- @param integer streamId streamId
-- @param integer connection connection
function ClearContractsEvent:writeStream(streamId, connection)

end


---Run action on receiving side
-- @param integer connection connection
function ClearContractsEvent:run(connection)
    if g_server ~= nil and connection:getIsServer() == false then
        g_server:broadcastEvent(self, true)
    else
    local oldMissions = g_missionManager.missions
        for key,mission in pairs(oldMissions) do
            if(mission.status == 1) then
                g_missionManager:markMissionForDeletion(mission)
                g_missionManager:update(10)
            end
        end
        if g_inGameMenu ~= nil and g_inGameMenu.pageContracts ~=nil then
            g_inGameMenu.pageContracts:updateList()
        end
    end

end

